function [OLS1,OLS2,OLSC1,OLSC2,IVC1,IVC2]= doRegressions(VAR,REG)
lags = VAR.NWlags;
% Local Projection 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
dY1      = REG.vars_inc-lagmatrix(REG.vars_inc,1);
dY2      = lagmatrix(REG.vars_inc,-1)-lagmatrix(REG.vars_inc,1);
dTAX     = -(REG.vars_tax-lagmatrix(REG.vars_tax,1));
N        = size(dTAX,2);
for j=1:N
controls(:,:,j) = [lagmatrix(REG.vars_inc(:,j),1:VAR.p),lagmatrix(REG.vars_tax(:,j),1:VAR.p),lagmatrix(VAR.vars(:,2:end-1),1:VAR.p) VAR.DET]; 
end    

    % A. OLS, no controls
    %%%%%%%%%%%%%%%%%%%%%
    sel1    = (isnan(dY1(:,1))+isnan(dTAX(:,1)))==0;
    T    = sum(sel1);
    sample1 = VAR.dates(sel1);
    for j = 1:N
    X = [dTAX(sel1,j) ones(sum(sel1),1)];
    b = X\dY1(sel1,j);
    nwse = NeweyWest(dY1(sel1,j)-X*b,X,lags);
    OLS1.b(1,j)    = b(1,:);
    OLS1.seb(1,j)  = nwse(1,:);
    OLS1.CI90(:,j) = [b(1,:)-tinv(0.95,T-size(X,2))* OLS1.seb(1,j);b(1,:)+tinv(0.95,T-size(X,2))* OLS1.seb(1,j) ];
    OLS1.CI95(:,j) = [b(1,:)-tinv(0.975,T-size(X,2))* OLS1.seb(1,j);b(1,:)+tinv(0.975,T-size(X,2))* OLS1.seb(1,j) ];
    OLS1.CI99(:,j) = [b(1,:)-tinv(0.995,T-size(X,2))* OLS1.seb(1,j);b(1,:)+tinv(0.995,T-size(X,2))* OLS1.seb(1,j) ];
    end
    OLS1.nobs = T;
    OLS1.sample = [sample1(1) sample1(end)];
    

    sel2    = (isnan(dY2(:,1))+isnan(dTAX(:,1)))==0;
    T    = sum(sel2);
    sample2 = VAR.dates(sel2);
    for j = 1:N
    X     = [dTAX(sel2,j) ones(sum(sel2),1)];    
    b     =  X\dY2(sel2,j);
    nwse = NeweyWest(dY2(sel2,j)-X*b,X,lags);
 
    OLS2.b(1,j)    = b(1,:);
    OLS2.seb(1,j)  = nwse(1,:);
    OLS2.CI90(:,j) = [b(1,:)-tinv(0.95,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.95,T-size(X,2))*nwse(1,:)];
    OLS2.CI95(:,j) = [b(1,:)-tinv(0.975,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.975,T-size(X,2))*nwse(1,:)];
    OLS2.CI99(:,j) = [b(1,:)-tinv(0.995,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.995,T-size(X,2))*nwse(1,:)];
    end
    OLS2.nobs = T;
    OLS2.sample = [sample2(1) sample2(end)];
        
    % B. OLS, controls
    %%%%%%%%%%%%%%%%%%
    sel1    = (isnan(dY1(:,1))+isnan(sum(controls(:,:,j),2))+isnan(dTAX(:,1)))==0;
    T       = sum(sel1);
 
    sample1 = VAR.dates(sel1);
    for j = 1:N
    X = [dTAX(sel1,j) controls(sel1,:,j)];    
    b =  X\dY1(sel1,j);
    nwse = NeweyWest(dY1(sel1,j)-X*b,X,lags);
    OLSC1.b(1,j)    = b(1,1);
    OLSC1.seb(1,j)  = nwse(1,:);
    OLSC1.CI90(:,j) = [b(1,:)-tinv(0.95,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.95,T-size(X,2))*nwse(1,:)];
    OLSC1.CI95(:,j) = [b(1,:)-tinv(0.975,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.975,T-size(X,2))*nwse(1,:)];
    OLSC1.CI99(:,j) = [b(1,:)-tinv(0.995,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.995,T-size(X,2))*nwse(1,:)];

    end
    OLSC1.nobs      = T;
    OLSC1.sample    = [sample1(1) sample1(end)];
    
    sel2    = (isnan(dY2(:,1))+isnan(sum(controls(:,:,j),2))+isnan(dTAX(:,1)))==0;
    T       = sum(sel2);
    sample2 = VAR.dates(sel2);
    for j = 1:N
    X  = [dTAX(sel2,j) controls(sel2,:,j)];    
    b  =  X\dY2(sel2,j);
    nwse = NeweyWest(dY2(sel2,j)-X*b,X,lags);
    OLSC2.b(1,j)    = b(1,1);
    OLSC2.seb(1,j)  = nwse(1,:);
    OLSC2.CI90(:,j) = [b(1,:)-tinv(0.95,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.95,T-size(X,2))*nwse(1,:)];
    OLSC2.CI95(:,j) = [b(1,:)-tinv(0.975,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.975,T-size(X,2))*nwse(1,:)];
    OLSC2.CI99(:,j) = [b(1,:)-tinv(0.995,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.995,T-size(X,2))*nwse(1,:)];
    end
    OLSC2.nobs   = T; 
    OLSC2.sample = [sample2(1) sample2(end)];

    % C. Controls, IV
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % First Stage
    INS     = REG.INS/100;
   % [IV1,IV2] = doIV(dY1,dY2,dTAX,INS,[],VAR,N);
    [IVC1,IVC2] = doIV(dY1,dY2,dTAX,INS,controls,VAR,N,lags);
          
%     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    function [IV1,IV2] = doIV(dY1,dY2,dTAX,INS,controls,VAR,N,lags)
    dTAXhat = NaN*zeros(size(dTAX));
   
    for j = 1:N
    if isempty(controls)==0
        sel1_fs = (isnan(sum(controls(:,:,j),2))+isnan(INS(:,j))+isnan(dTAX(:,j)))==0; 
    T = sum(sel1_fs);
    X_fs    = [INS(sel1_fs,j) controls(sel1_fs,:,j)];
    else
        sel1_fs = (isnan(INS(:,j))+isnan(dTAX(:,j)))==0;
    T = sum(sel1_fs);    
    X_fs    = [INS(sel1_fs,j) ones(T,1)];
    end
    b_fs    = X_fs\dTAX(sel1_fs,j);
    nwse    = NeweyWest(dTAX(sel1_fs,j)-X_fs*b_fs,X_fs,lags);   
    dTAXhat(sel1_fs,j) =X_fs*b_fs;    
    IV1.Fstat(:,j) = b_fs(1,1).^2./(((nwse(1,1))).^2); % F stat on excluded instrument
    IV1.b_fs(:,j)  = b_fs(1,1);
    IV2.Fstat(:,j) = IV1.Fstat(:,j);
    IV2.b_fs(:,j)  = IV1.b_fs(:,j);
    end
     
    for j = 1:N
    if isempty(controls)==0 
        sel1    = (isnan(dY1(:,1))+isnan(sum(controls(:,:,j),2))+isnan(dTAXhat(:,1)))==0;
    T = sum(sel1);
    sample1 = VAR.dates(sel1);     
    X = [dTAXhat(sel1,j) controls(sel1,:,j)];   
    XX = [dTAX(sel1,j) controls(sel1,:,j)]; 
    V = [INS(sel1,j) controls(sel1,:,j)];
    else
        sel1    = (isnan(dY1(:,1))+isnan(dTAXhat(:,1)))==0;
    T = sum(sel1);
    sample1 = VAR.dates(sel1);         
    X = [dTAXhat(sel1,j) ones(T,1)];   
    XX = [dTAX(sel1,j) ones(T,1)]; 
    V = [INS(sel1,j) ones(T,1)];   
     end
    b = X\dY1(sel1,j);
   [nwse,Q]          = NeweyWest(dY1(sel1,j)-XX*b,V,lags);
    nwse= sqrt(diag((T)*((V'*XX)\Q/(XX'*V))));
    IV1.b(1,j)    = b(1,1);
    IV1.seb(1,j)  = nwse(1,1);
    IV1.CI90(:,j) = [b(1,:)-tinv(0.95,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.95,T-size(X,2))*nwse(1,:)];
    IV1.CI95(:,j) = [b(1,:)-tinv(0.975,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.975,T-size(X,2))*nwse(1,:)];
    IV1.CI99(:,j) = [b(1,:)-tinv(0.995,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.995,T-size(X,2))*nwse(1,:)];
    end
    IV1.nobs      = T;
    IV1.sample    = [sample1(1) sample1(end)];
       
  
    for j = 1:N
    if isempty(controls)==0 
        sel2    = (isnan(dY2(:,j))+isnan(sum(controls(:,:,j),2))+isnan(dTAXhat(:,1)))==0;
    sample2 = VAR.dates(sel2);
    T  =  sum(sel2);    
    X  = [dTAXhat(sel2,j) controls(sel2,:,j)];
    XX = [dTAX(sel2,j) controls(sel2,:,j)]; 
    V = [INS(sel2,j) controls(sel2,:,j)];
    else
        sel2    = (isnan(dY2(:,j))+isnan(dTAXhat(:,1)))==0;
    sample2 = VAR.dates(sel2);
    T  =  sum(sel2);      
    X  = [dTAXhat(sel2,j) ones(T,1)];
    XX = [dTAX(sel2,j) ones(T,1)]; 
    V = [INS(sel2,j) ones(T,1)];
    end
    b  =  X\dY2(sel2,j);
    [nwse,Q]      = NeweyWest(dY2(sel2,j)-XX*b,V,lags);
    nwse= sqrt(diag((T)*((V'*XX)\Q/(XX'*V))));
    IV2.b(1,j)    = b(1,1);
    IV2.seb(1,j)  = nwse(1,1);
    IV2.CI90(:,j) = [b(1,:)-tinv(0.95,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.95,T-size(X,2))*nwse(1,:)];
    IV2.CI95(:,j) = [b(1,:)-tinv(0.975,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.975,T-size(X,2))*nwse(1,:)];
    IV2.CI99(:,j) = [b(1,:)-tinv(0.995,T-size(X,2))*nwse(1,:);b(1,:)+tinv(0.995,T-size(X,2))*nwse(1,:)];
    end
    IV2.nobs   = T;
    IV2.sample = [sample2(1) sample2(end)];    
   

